<?php
if (!defined("B_PROLOG_INCLUDED") || B_PROLOG_INCLUDED !== true) die();

use Bitrix\Main\Application,
    Bitrix\Main\Engine\CurrentUser,
    Bitrix\Sale\Archive\Manager,
    Bitrix\Sale\Order;


// Если не авторизован отправляем на главную
if (!$USER->IsAuthorized()) {
    LocalRedirect('/');
    exit;
}

// ID пользователя
$arResult['USER_ID'] = CurrentUser::get()->getId();

//  Работа с запросом
$request = Application::getInstance()->getContext()->getRequest();
$deleteUser = $request->getPost('CONFIRM_DELETE');


if ($deleteUser) {
    $user = new CUser;
    if ($arParams['MODE_SWITCHER'] == 'DEACTIVATE_USER_ACC') {
        // Если режим деактивации, просто деакивируем пользователя
        // Не трогая заказы
        $arFields = array(
            'ACTIVE' => 'N',
        );
        $user->Update(
            $arResult['USER_ID'],
            $arFields
        );
        LocalRedirect('/');
        exit;
        //$strError .= $user->LAST_ERROR;
    } else {
        // Если удаление, архивируем все заказы пользователя
        // получаем заказы связанные с пользователем
        $dbResOrders = Order::getList([
            'filter' => [
                "USER_ID" => $arResult['USER_ID'],
            ],
            'select' => [
                'ID' // Нужен только ID
            ],
        ])->fetchAll();
        $arOrders = [];
        foreach ($dbResOrders as $dbResOrder) {
            $arOrders[] = $dbResOrder['ID'];
        }
        // Архивируем заказы
        if (!empty($arOrders)) {
            Manager::archiveOrders(
                [
                    'ID' => $arOrders
                ]
            );
        }
        CUser::Delete( $arResult['USER_ID']);
        LocalRedirect('/');
        exit;
    }
}

$this->includeComponentTemplate();



