<?
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED!==true) die();

use Bitrix\Main\Loader;
use Bitrix\Catalog;
use Bitrix\Iblock;
use Bitrix\Main\Web\Json;

CBitrixComponent::includeComponentClass($componentName);

$arTemplateParameters['COLUMNS_LIST_MOBILE'] = array(
	'PARENT' => 'VISUAL',
	'NAME' => GetMessage('CP_SBB_TPL_COLUMNS_LIST_MOBILE'),
	'TYPE' => 'LIST',
	'COLS' => 25,
	'SIZE' => 7,
	'MULTIPLE' => 'Y',
);

$themes = array();




$arTemplateParameters['DEFERRED_REFRESH'] = array(
	'PARENT' => 'BASE',
	'NAME' => GetMessage('CP_SBB_TPL_DEFERRED_REFRESH'),
	'TYPE' => 'CHECKBOX',
	'DEFAULT' => 'N'
);
$arTemplateParameters['USE_DYNAMIC_SCROLL'] = array(
	'PARENT' => 'BASE',
	'NAME' => GetMessage('CP_SBB_TPL_USE_DYNAMIC_SCROLL'),
	'TYPE' => 'CHECKBOX',
	'DEFAULT' => 'Y'
);

$arTemplateParameters['SHOW_RESTORE'] = array(
	'PARENT' => 'BASE',
	'NAME' => GetMessage('CP_SBB_TPL_SHOW_RESTORE'),
	'TYPE' => 'CHECKBOX',
	'DEFAULT' => 'Y'
);
$arTemplateParameters['EMPTY_BASKET_HINT_PATH'] = [
	'PARENT' => 'ADDITIONAL_SETTINGS',
	"NAME" => GetMessage('CP_SBB_EMPTY_BASKET_HINT_PATH'),
	"TYPE" => "STRING",
	"DEFAULT" => "/"
];


$arTemplateParameters['DISPLAY_MODE'] = array(
	'PARENT' => 'VISUAL',
	'NAME' => GetMessage('CP_SBB_TPL_DISPLAY_MODE'),
	'TYPE' => 'LIST',
	'VALUES' => array(
		'extended' => GetMessage('CP_SBB_TPL_DISPLAY_MODE_EXTENDED'),
		'compact' => GetMessage('CP_SBB_TPL_DISPLAY_MODE_COMPACT')
	),
	'DEFAULT' => 'extended'
);
$arTemplateParameters['PRICE_DISPLAY_MODE'] = array(
	'PARENT' => 'VISUAL',
	'NAME' => GetMessage('CP_SBB_TPL_PRICE_DISPLAY_MODE'),
	'TYPE' => 'CHECKBOX',
	'DEFAULT' => 'Y'
);
$arTemplateParameters['SHOW_DISCOUNT_PERCENT'] = array(
	'PARENT' => 'VISUAL',
	'NAME' => GetMessage('CP_SBB_TPL_SHOW_DISCOUNT_PERCENT'),
	'TYPE' => 'CHECKBOX',
	'REFRESH' => 'Y',
	'DEFAULT' => 'Y'
);

if (!isset($arCurrentValues['SHOW_DISCOUNT_PERCENT']) || $arCurrentValues['SHOW_DISCOUNT_PERCENT'] === 'Y')
{
	$arTemplateParameters['DISCOUNT_PERCENT_POSITION'] = array(
		'PARENT' => 'VISUAL',
		'NAME' => GetMessage('CP_SBB_TPL_DISCOUNT_PERCENT_POSITION'),
		'TYPE' => 'CUSTOM',
		'JS_FILE' => CBitrixBasketComponent::getSettingsScript($componentPath, 'position'),
		'JS_EVENT' => 'initPositionControl',
		'JS_DATA' => Json::encode(
			array(
				'positions' => array(
					'top-left', 'top-center', 'top-right',
					'middle-left', 'middle-center', 'middle-right',
					'bottom-left', 'bottom-center', 'bottom-right'
				),
				'className' => 'bx-pos-parameter-block-circle'
			)
		),
		'DEFAULT' => 'bottom-right'
	);
}

$arTemplateParameters['PRODUCT_BLOCKS_ORDER'] = array(
	'PARENT' => 'VISUAL',
	'NAME' => GetMessage('CP_SBB_TPL_PRODUCT_BLOCKS_ORDER'),
	'TYPE' => 'CUSTOM',
	'JS_FILE' => CBitrixBasketComponent::getSettingsScript($componentPath, 'dragdrop_order'),
	'JS_EVENT' => 'initDraggableOrderControl',
	'JS_DATA' => Json::encode(array(
		'props' => GetMessage('CP_SBB_TPL_PRODUCT_BLOCK_PROPERTIES'),
		'sku' => GetMessage('CP_SBB_TPL_PRODUCT_BLOCK_SKU'),
		'columns' => GetMessage('CP_SBB_TPL_PRODUCT_BLOCK_COLUMNS')
	)),
	'DEFAULT' => 'props,sku,columns'
);
$arTemplateParameters['USE_PRICE_ANIMATION'] = array(
	'PARENT' => 'VISUAL',
	'NAME' => GetMessage('CP_SBB_TPL_USE_PRICE_ANIMATION'),
	'TYPE' => 'CHECKBOX',
	'DEFAULT' => 'Y'
);
$arTemplateParameters['LABEL_PROP'] = array(
	'PARENT' => 'VISUAL',
	'NAME' => GetMessage('CP_SBB_TPL_LABEL_PROP'),
	'TYPE' => 'LIST',
	'MULTIPLE' => 'Y',
	'ADDITIONAL_VALUES' => 'N',
	'COLS' => 25,
	'SIZE' => 7,
	'REFRESH' => 'Y'
);

if (!empty($arCurrentValues['LABEL_PROP']))
{
	$arTemplateParameters['LABEL_PROP_MOBILE'] = array(
		'PARENT' => 'VISUAL',
		'NAME' => GetMessage('CP_SBB_TPL_LABEL_PROP_MOBILE'),
		'TYPE' => 'LIST',
		'MULTIPLE' => 'Y',
		'ADDITIONAL_VALUES' => 'N',
		'COLS' => 25,
		'SIZE' => 7,
		'REFRESH' => 'N',
	);

	$arTemplateParameters['LABEL_PROP_POSITION'] = array(
		'PARENT' => 'VISUAL',
		'NAME' => GetMessage('CP_SBB_TPL_LABEL_PROP_POSITION'),
		'TYPE' => 'CUSTOM',
		'JS_FILE' => CBitrixBasketComponent::getSettingsScript($componentPath, 'position'),
		'JS_EVENT' => 'initPositionControl',
		'JS_DATA' => Json::encode(
			array(
				'positions' => array(
					'top-left', 'top-center', 'top-right',
					'middle-left', 'middle-center', 'middle-right',
					'bottom-left', 'bottom-center', 'bottom-right'
				),
				'className' => ''
			)
		),
		'DEFAULT' => 'top-left'
	);
}

