<? if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) die();

use Bitrix\Main\Localization\Loc;

/**
 * @var array $mobileColumns
 * @var array $arParams
 * @var string $templateFolder
 */

$usePriceInAdditionalColumn = in_array('PRICE', $arParams['COLUMNS_LIST']) && $arParams['PRICE_DISPLAY_MODE'] === 'Y';
$useSumColumn = in_array('SUM', $arParams['COLUMNS_LIST']);
$useActionColumn = in_array('DELETE', $arParams['COLUMNS_LIST']);

$restoreColSpan = 2 + $usePriceInAdditionalColumn + $useSumColumn + $useActionColumn;

$positionClassMap = array(
    'left' => 'basket-item-label-left',
    'center' => 'basket-item-label-center',
    'right' => 'basket-item-label-right',
    'bottom' => 'basket-item-label-bottom',
    'middle' => 'basket-item-label-middle',
    'top' => 'basket-item-label-top'
);

$discountPositionClass = '';
if ($arParams['SHOW_DISCOUNT_PERCENT'] === 'Y' && !empty($arParams['DISCOUNT_PERCENT_POSITION'])) {
    foreach (explode('-', $arParams['DISCOUNT_PERCENT_POSITION']) as $pos) {
        $discountPositionClass .= isset($positionClassMap[$pos]) ? ' ' . $positionClassMap[$pos] : '';
    }
}

$labelPositionClass = '';
if (!empty($arParams['LABEL_PROP_POSITION'])) {
    foreach (explode('-', $arParams['LABEL_PROP_POSITION']) as $pos) {
        $labelPositionClass .= isset($positionClassMap[$pos]) ? ' ' . $positionClassMap[$pos] : '';
    }
}
?>
<script id="basket-item-template" type="text/html">
    <tr class="basket-items-list-item-container"
        id="basket-item-{{ID}}" data-entity="basket-item" data-id="{{ID}}">
        {{#SHOW_RESTORE}}

        <td colspan="<?= $restoreColSpan ?>">
            <div class="good_remove_from_cart" id="basket-item-height-aligner-{{ID}}">

                <div class="good_remove_from_cart_text">
                    <strong>{{NAME}} <?= Loc::getMessage('SBB_BASKET_ITEM_DELETED') ?></strong>
                    <a class="btn" href="javascript:void(0)" data-entity="basket-item-restore-button">
                        <?= Loc::getMessage('SBB_BASKET_ITEM_RESTORE') ?>
                    </a>
                </div>
            </div>
        </td>

        {{/SHOW_RESTORE}}
        {{^SHOW_RESTORE}}
        <td class="basket-item-descriptions">
            <div class="basket-item-descriptions_image" id="basket-item-height-aligner-{{ID}}">
                <?
                if (in_array('PREVIEW_PICTURE', $arParams['COLUMNS_LIST']))
                {
                ?>
                <img src="{{{IMAGE_URL}}}{{^IMAGE_URL}}<?= $templateFolder ?>/images/no_photo.png{{/IMAGE_URL}}">
                <?
                if ($arParams['SHOW_DISCOUNT_PERCENT'] === 'Y') {
                    ?>
                    {{#DISCOUNT_PRICE_PERCENT}}
                    <div class="basket-item-descriptions_image_lable">
                        -{{DISCOUNT_PRICE_PERCENT_FORMATED}}
                    </div>
                    {{/DISCOUNT_PRICE_PERCENT}}
                    <?
                }
                ?>
            </div>
            <?
            }
            ?>
            <div class="basket-item-descriptions_info">
                {{#DETAIL_PAGE_URL}}
                <a href="{{DETAIL_PAGE_URL}}" class="basket-item-descriptions_info_link">
                    {{/DETAIL_PAGE_URL}}
                    <span data-entity="basket-item-name">{{NAME}}</span>
                    {{#DETAIL_PAGE_URL}}
                </a>
                {{/DETAIL_PAGE_URL}}

                {{#NOT_AVAILABLE}}
                <div class="alert alert-warning text-center">
                        <?= Loc::getMessage('SBB_BASKET_ITEM_NOT_AVAILABLE') ?>.
                </div>
                {{/NOT_AVAILABLE}}

                {{#WARNINGS.length}}
                <div>
                    <div class="alert alert-warning alert-dismissable" data-entity="basket-item-warning-node">
                        <span class="close" data-entity="basket-item-warning-close">x</span>
                        {{#WARNINGS}}
                        <div data-entity="basket-item-warning-text">{{{.}}}</div>
                        {{/WARNINGS}}
                    </div>
                </div>
                {{/WARNINGS.length}}
                <div class="basket-item-block-properties">
                    <?
                    if (!empty($arParams['PRODUCT_BLOCKS_ORDER'])) {
                        foreach ($arParams['PRODUCT_BLOCKS_ORDER'] as $blockName) {
                            switch (trim((string)$blockName)) {
                                case 'sku':
                                    ?>
                                    {{#SKU_BLOCK_LIST}}
                                    {{#IS_IMAGE}}
                                    <div data-entity="basket-item-sku-block" class="scu_block_selector">
                                        <div class="scu_block_selector_title">{{NAME}}</div>

                                        <ul>
                                            {{#SKU_VALUES_LIST}}
                                            <li class="{{#SELECTED}} selected{{/SELECTED}}
																		{{#NOT_AVAILABLE_OFFER}} not-available{{/NOT_AVAILABLE_OFFER}}"
                                                data-entity="basket-item-sku-field"
                                                data-initial="{{#SELECTED}}true{{/SELECTED}}{{^SELECTED}}false{{/SELECTED}}"
                                                data-value-id="{{VALUE_ID}}"
                                                data-sku-name="{{NAME}}"
                                                data-property="{{PROP_CODE}}">
                                                <span style="background-image: url({{PICT}});"></span>
                                            </li>
                                            {{/SKU_VALUES_LIST}}
                                        </ul>

                                    </div>
                                    {{/IS_IMAGE}}

                                    {{^IS_IMAGE}}
                                    <div data-entity="basket-item-sku-block" class="scu_block_selector">
                                        <div class="scu_block_selector_title">{{NAME}}</div>

                                        <ul>
                                            {{#SKU_VALUES_LIST}}
                                            <li class="{{#SELECTED}} selected{{/SELECTED}}
																		{{#NOT_AVAILABLE_OFFER}} not-available{{/NOT_AVAILABLE_OFFER}}"
                                                data-entity="basket-item-sku-field"
                                                data-initial="{{#SELECTED}}true{{/SELECTED}}{{^SELECTED}}false{{/SELECTED}}"
                                                data-value-id="{{VALUE_ID}}"
                                                data-sku-name="{{NAME}}"
                                                data-property="{{PROP_CODE}}">
                                                {{NAME}}
                                            </li>
                                            {{/SKU_VALUES_LIST}}
                                        </ul>

                                    </div>
                                    {{/IS_IMAGE}}
                                    {{/SKU_BLOCK_LIST}}

                                    {{#HAS_SIMILAR_ITEMS}}
                                    <div class="basket-items-list-item-double"
                                         data-entity="basket-item-sku-notification">
                                        <div class="alert alert-info alert-dismissable text-center">
                                            {{#USE_FILTER}}
                                            <a href="javascript:void(0)"
                                               class="basket-items-list-item-double-anchor"
                                               data-entity="basket-item-show-similar-link">
                                                {{/USE_FILTER}}
                                                <?= Loc::getMessage('SBB_BASKET_ITEM_SIMILAR_P1') ?>{{#USE_FILTER}}</a>{{/USE_FILTER}}
                                            <?= Loc::getMessage('SBB_BASKET_ITEM_SIMILAR_P2') ?>
                                            {{SIMILAR_ITEMS_QUANTITY}} {{MEASURE_TEXT}}
                                            <br>
                                            <a href="javascript:void(0)" class="basket-items-list-item-double-anchor"
                                               data-entity="basket-item-merge-sku-link">
                                                <?= Loc::getMessage('SBB_BASKET_ITEM_SIMILAR_P3') ?>
                                                {{TOTAL_SIMILAR_ITEMS_QUANTITY}} {{MEASURE_TEXT}}?
                                            </a>
                                        </div>
                                    </div>
                                    {{/HAS_SIMILAR_ITEMS}}
                                    <?
                                    break;
                            }
                        }
                    }
                    ?>
                </div>
            </div>
        </td>
        <?
        if ($usePriceInAdditionalColumn) {
            ?>
            <td>
                <div class="basket_price_column">
                    {{#SHOW_DISCOUNT_PRICE}}
                    <del>
                        {{{FULL_PRICE_FORMATED}}}
                    </del>
                    {{/SHOW_DISCOUNT_PRICE}}
                    <span id="basket-item-price-{{ID}}">
						{{{PRICE_FORMATED}}}
					</span>
                    <i>
                        <?= Loc::getMessage('SBB_BASKET_ITEM_PRICE_FOR') ?> {{MEASURE_RATIO}} {{MEASURE_TEXT}}
                    </i>
                </div>
            </td>
            <?
        }
        ?>
        <td>
            <div class="{{#NOT_AVAILABLE}} disabled{{/NOT_AVAILABLE}}"
                 data-entity="basket-item-quantity-block">
                <span data-entity="basket-item-quantity-minus">
                    -
                </span>
                <input
                        type="text"
                        value="{{QUANTITY}}"
                        {{#NOT_AVAILABLE}} disabled="disabled" {{/NOT_AVAILABLE}}
                data-value="{{QUANTITY}}" data-entity="basket-item-quantity-field"
                id="basket-item-quantity-{{ID}}">
                <span data-entity="basket-item-quantity-plus">
                    +
                </span>
            </div>
        </td>
        <?
        if ($useSumColumn) {
            ?>
            <td>


							<span id="basket-item-sum-price-{{ID}}">
								{{{SUM_PRICE_FORMATED}}}
							</span>


                {{#SHOW_DISCOUNT_PRICE}}
                <div>
                    <?= Loc::getMessage('SBB_BASKET_ITEM_ECONOMY') ?>
                    <span id="basket-item-sum-price-difference-{{ID}}" style="white-space: nowrap;">
							{{{SUM_DISCOUNT_PRICE_FORMATED}}}
					</span>
                </div>
                {{/SHOW_DISCOUNT_PRICE}}


            </td>
            <?
        }

        if ($useActionColumn) {
            ?>
            <td>
                    <span class="basket-item-actions-remove" data-entity="basket-item-delete">
                       Удалить
                    </span>
            </td>
            <?
        }
        ?>
        {{/SHOW_RESTORE}}
    </tr>
</script>