# BXSTORE Flutter App

> **Кроссплатформенное WebView-приложение для iOS и Android с поддержкой push-уведомлений, локализацией и интеграцией Firebase.**

---

## Оглавление
1. [Описание](#описание)
2. [Основные возможности](#основные-возможности)
3. [Быстрый старт](#быстрый-старт)
4. [Создание проекта с нуля](#создание-проекта-с-нуля)
5. [Структура проекта](#структура-проекта)
6. [Работа push-токена и WebView](#работа-push-токена-и-webview)
7. [Геолокация и User-Agent](#геолокация-и-user-agent)
8. [Важные замечания](#важные-замечания)
9. [Настройка Firebase и FlutterFire CLI](#настройка-firebase-и-flutterfire-cli)
10. [Публикация в App Store и Google Play](#публикация-в-app-store-и-google-play)
11. [FAQ](#faq)
12. [Контакты и поддержка](#контакты-и-поддержка)
13. [Лицензия](#лицензия)

---

## Описание

BXSTORE — кроссплатформенное мобильное приложение на Flutter для iOS и Android, работающее как WebView-клиент сайта [bxstore.ru/mobileapp](https://bxstore.ru/mobileapp/) с поддержкой push-уведомлений через Firebase, локализацией (русский/английский), фирменным цветом (#67A900), кастомной иконкой и проверкой интернет-соединения.

---

## Основные возможности
- **WebView**: отображение сайта внутри приложения
- **Push-уведомления**: интеграция с Firebase Cloud Messaging (FCM)
- **Локализация**: поддержка русского и английского языков
- **Проверка интернета**: вывод сообщения при отсутствии соединения
- **Кастомная иконка**: собственная иконка приложения
- **Фирменный цвет**: статусбар и AppBar окрашены в #67A900
- **Чистый код**: подробные комментарии на русском языке
- **Только iOS и Android**: проект не содержит лишних платформ

---

## Быстрый старт

### 1. Установка Flutter
- [Инструкция по установке Flutter](https://docs.flutter.dev/get-started/install)
- Добавьте Flutter в PATH
- Проверьте установку:
  ```sh
  flutter doctor
  ```

### 2. Клонирование и подготовка проекта
```sh
git clone <адрес-репозитория>
cd ru_tech_bxstore
flutter pub get
```

### 3. Копирование файлов Firebase
- Android: `google-services.json` → `android/app/`
- iOS: `GoogleService-Info.plist` → `ios/Runner/`

### 4. Генерация иконок приложения
1. Поместите исходную иконку (например, `ico.png`) в `SRC_RESOURCES/`
2. В `pubspec.yaml`:
   ```yaml
   flutter_icons:
     android: true
     ios: true
     image_path: "SRC_RESOURCES/ico.png"
   ```
3. Установите пакет и сгенерируйте иконки:
   ```sh
   flutter pub get
   flutter pub run flutter_launcher_icons:main
   ```

### 5. Сборка и запуск
- Android:
  ```sh
  flutter run -d android
  ```
- iOS:
  ```sh
  cd ios
  pod install
  cd ..
  flutter run -d ios
  ```
  > **Важно!** Для запуска на iOS требуется Xcode и Mac.

---

## Создание проекта с нуля

1. Создайте новый проект:
   ```sh
   flutter create --org ru.tech.bxstore --platforms=android,ios bxstore
   cd bxstore
   ```
2. Удалите лишние платформы:
   ```sh
   rm -rf linux macos windows web
   ```
3. Добавьте зависимости в `pubspec.yaml`:
   ```yaml
   dependencies:
     flutter:
       sdk: flutter
     cupertino_icons: ^1.0.8
     flutter_localizations:
       sdk: flutter
     flutter_inappwebview: ^6.1.5
     connectivity_plus: ^6.0.3
     firebase_core: ^3.0.0
     firebase_messaging: ^15.0.0
   dev_dependencies:
     flutter_launcher_icons: ^0.13.1
   ```
4. Добавьте иконку и настройте секцию `flutter_icons` в `pubspec.yaml`:
   ```yaml
   flutter_icons:
     android: true
     ios: true
     image_path: "SRC_RESOURCES/ico.png"
   ```
5. Сгенерируйте иконки:
   ```sh
   flutter pub get
   flutter pub run flutter_launcher_icons:main
   ```
6. Скопируйте файлы Firebase:
   - `android/app/google-services.json`
   - `ios/Runner/GoogleService-Info.plist`
7. Реализуйте WebView, push-уведомления, локализацию (см. пример в этом проекте)
8. Соберите и запустите приложение:
   ```sh
   flutter run -d android # или -d ios
   ```

---

## Структура проекта
- `lib/main.dart` — основной код приложения
- `pubspec.yaml` — зависимости и настройки
- `SRC_RESOURCES/ico.png` — иконка приложения
- `android/app/google-services.json` — настройки Firebase для Android
- `ios/Runner/GoogleService-Info.plist` — настройки Firebase для iOS

---

## Работа push-токена и WebView

### Push-токен
- После запуска приложения токен устройства автоматически передаётся на сайт через JavaScript:
  ```js
  window.setFcmToken = function(token) {
    alert("FCM токен устройства: " + token);
    // Здесь можно сохранить токен или отправить его на сервер
  };
  ```
- На сайте реализуйте функцию `window.setFcmToken(token)` для получения токена.
- Токен можно использовать для отправки push-уведомлений через Firebase Cloud Messaging.

### Передача FCM-токена в WebView
- После получения push-токена приложение передаёт его на сайт через JS-функцию `window.setFcmToken(token)`.
- Для надёжности реализована повторная отправка токена через 2 секунды после загрузки страницы:
  ```dart
  onLoadStop: (controller, url) {
    if (_fcmToken != null) {
      _sendTokenToWeb(_fcmToken!);
      Future.delayed(const Duration(seconds: 2), () {
        _sendTokenToWeb(_fcmToken!);
      });
    }
  },
  ```
- На сайте функция должна быть определена в глобальной области видимости до загрузки сторонних JS.

---

## Геолокация и User-Agent

### Геолокация
- Приложение запрашивает разрешение на доступ к GPS и получает координаты устройства.
- Координаты передаются на сайт через функцию:
  ```js
  window.setDeviceLocation(lat, lng)
  ```
- На сайте реализуйте:
  ```js
  window.setDeviceLocation = function(lat, lng) {
    alert("Координаты устройства: " + lat + ", " + lng);
  };
  ```
- Если пользователь не дал разрешение или отключил GPS — координаты не будут переданы.

### User-Agent
- В WebView установлен кастомный User-Agent: `BXSTORE`.
- Это позволяет сайту отличать запросы из приложения от браузера.
- Проверить User-Agent можно через JS:
  ```js
  navigator.userAgent // содержит 'BXSTORE'
  ```

---

## Важные замечания
- **Firebase:**
  - Для работы push-уведомлений настройте проект в [Firebase Console](https://console.firebase.google.com/)
  - Скачайте свои файлы конфигурации и поместите их в нужные папки.
  - Для Android: убедитесь, что в `android/app/build.gradle` подключён плагин `com.google.gms.google-services`.
  - Для iOS: в Xcode включите Background Modes > Remote notifications.
- **Публикация:**
  - Для публикации потребуется аккаунт разработчика и настройка подписи приложения.
  - Проверьте все разрешения и настройки Info.plist/AndroidManifest.xml.
- **Локализация:**
  - Для добавления языков — добавьте их в `supportedLocales` и используйте локализованные строки.
- **WebView:**
  - Для передачи данных между приложением и сайтом используйте методы evaluateJavascript и window-объекты.
- **Обновление зависимостей:**
  - Регулярно обновляйте пакеты командой `flutter pub upgrade`.
- **Отладка:**
  - Для просмотра токена используйте вывод в консоль или передавайте его на сайт.
- **Безопасность:**
  - Не храните приватные ключи и пароли в открытом виде в репозитории.
  - Используйте переменные окружения для чувствительных данных.

---

## Настройка Firebase и FlutterFire CLI

1. Установите Firebase CLI (требуется Node.js):
   ```sh
   npm install -g firebase-tools
   ```
2. Выполните вход в Firebase:
   ```sh
   firebase login
   ```
3. Установите FlutterFire CLI:
   ```sh
   dart pub global activate flutterfire_cli
   ```
   Добавьте путь к глобальным Dart-пакетам в PATH:
   ```sh
   echo 'export PATH="$PATH:$HOME/.pub-cache/bin"' >> ~/.zshrc
   source ~/.zshrc
   ```
4. Сгенерируйте файл firebase_options.dart:
   ```sh
   flutterfire configure
   ```
   Выберите проект Firebase и платформы. После завершения появится файл `lib/firebase_options.dart`.
5. Используйте firebase_options.dart в main.dart:
   ```dart
   import 'firebase_options.dart';
   await Firebase.initializeApp(
     options: DefaultFirebaseOptions.currentPlatform,
   );
   ```

> **Без этого файла push-уведомления и другие сервисы Firebase работать не будут!**

---

## Публикация в App Store и Google Play

### Инструкция по публикации в App Store
1. Подготовьте иконки и скриншоты согласно требованиям App Store.
2. Убедитесь, что `GoogleService-Info.plist` в `ios/Runner/`.
3. Откройте проект в Xcode (`ios/Runner.xcworkspace`).
4. В Signing & Capabilities выберите Team и уникальный Bundle Identifier.
5. Выполните:
   ```sh
   flutter build ipa --release
   ```
   или используйте Xcode: Product → Archive.
6. В Xcode Organizer загрузите архив в App Store Connect.
7. Заполните информацию о приложении и отправьте на модерацию.
[Подробнее](https://docs.flutter.dev/deployment/ios)

### Инструкция по публикации в Google Play
1. Подготовьте иконки и скриншоты согласно требованиям Google Play.
2. Убедитесь, что `google-services.json` в `android/app/`.
3. Проверьте package name в `android/app/build.gradle.kts` и `AndroidManifest.xml`.
4. Выполните:
   ```sh
   flutter build appbundle --release
   ```
   Файл `.aab` будет в `build/app/outputs/bundle/release/app-release.aab`.
5. В Google Play Console создайте приложение и загрузите `.aab`.
6. Заполните информацию, настройте тестирование и отправьте на модерацию.
[Подробнее](https://docs.flutter.dev/deployment/android)

---

## FAQ

**Q: Почему не приходят push-уведомления?**
- Проверьте настройки Firebase, наличие актуальных конфигов и разрешения на уведомления.

**Q: Как добавить новый язык?**
- Добавьте язык в `supportedLocales` и создайте локализованные строки.

**Q: Как проверить, что WebView работает корректно?**
- Откройте приложение, убедитесь, что сайт загружается, push-токен и координаты передаются на сайт.

**Q: Как обновить зависимости?**
- Выполните `flutter pub upgrade`.

**Q: Как обезопасить ключи и пароли?**
- Используйте переменные окружения и не коммитьте приватные ключи в репозиторий.

---

## Контакты и поддержка
- [Документация Flutter](https://docs.flutter.dev/)
- [Документация Firebase](https://firebase.google.com/docs)

---

## Лицензия
Этот проект предоставляется "как есть". Используйте как шаблон для своих приложений.
